/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.calendar.api;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.silverpeas.calendar.api.CalendarEntry;
import org.silverpeas.calendar.api.SilverEvent;
import org.silverpeas.calendar.api.SilverEventsList;

public class CalendarEntriesFactory {
    private final String sessionId;

    public CalendarEntriesFactory(String sessionId) {
        this.sessionId = sessionId;
    }

    public List<CalendarEntry> buildJournalHeadersList(SilverEventsList myEvents) {
        ArrayList<CalendarEntry> headers = new ArrayList<CalendarEntry>(myEvents.getItemsListCount());
        for (int i = 1; i <= myEvents.getItemsListCount(); ++i) {
            headers.add(this.createJournalHeader(myEvents.getSilverEvent(i)));
        }
        return headers;
    }

    public CalendarEntry createJournalHeader(SilverEvent event) {
        CalendarEntry journal = new CalendarEntry(event.getSubject(), this.sessionId);
        journal.setDescription(event.getBody());
        journal.setPriority(event.getImportance());
        journal.setClassification(event.getSensitivity());
        journal.setStartDay(event.getStart());
        journal.setEndDay(event.getEnd());
        if (event.getAllDayEvent()) {
            journal.setStartHour(null);
            journal.setEndHour(null);
            Calendar cal = Calendar.getInstance();
            cal.setTime(event.getEnd());
            cal.add(6, -1);
            journal.setEndDay(cal.getTime());
        } else {
            journal.setStartHour(event.getStart());
            journal.setEndHour(event.getEnd());
        }
        journal.setExternalId(event.getEntryId());
        return journal;
    }
}

